#include "SetWorldGravityCommand.h"
#include "SimulationEngineController.h"
#include "../DataTypes/DataString.h"
#include "../DataTypes/Vector3f.h"
namespace SimulationEngine
{

SetWorldGravityCommand::SetWorldGravityCommand():ICommand(ConfigurationServer::GetInstance()->GetCommandSetWorldGravityKey())
{
}

SetWorldGravityCommand::~SetWorldGravityCommand()
{
}

list<DataParameter*> SetWorldGravityCommand::execute(list <DataParameter *> pars)
{
	Vector3f *gravvec = (Vector3f *)(pars.front());
	SimulationEngineController::GetInstance()->SetWorldGravity(gravvec->GetFirst(),gravvec->GetSecond(),gravvec->GetThird());
	list <DataParameter *> ret;
	ret.push_back(new DataString("World gravity has been successfully setted"));
	return ret;
}

}
